<?php
// Prevent direct access
if (!defined('ACCESS_ALLOWED')) {
    header('HTTP/1.0 403 Forbidden');
    exit;
}
?>

<header class="header">
    <div class="logo">
        <i class="material-icons">school</i>
        <h1>Excel Academy</h1>
    </div>
    
    <div class="user-menu">
        <div class="user-info">
            <div class="user-name"><?php echo $_SESSION['username']; ?></div>
            <div class="user-role"><?php echo ucfirst($_SESSION['role']); ?></div>
        </div>
        
        <div class="user-avatar">
            <i class="material-icons">person</i>
        </div>
        
        <div class="user-dropdown" style="display: none;">
            <a href="profile.php"><i class="material-icons">person</i> Profile</a>
            <a href="settings.php"><i class="material-icons">settings</i> Settings</a>
            <a href="logout.php"><i class="material-icons">logout</i> Logout</a>
        </div>
    </div>
</header>

<script>
// User dropdown functionality
document.querySelector('.user-avatar').addEventListener('click', function() {
    const dropdown = document.querySelector('.user-dropdown');
    dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
});

// Close dropdown when clicking outside
document.addEventListener('click', function(event) {
    const dropdown = document.querySelector('.user-dropdown');
    const avatar = document.querySelector('.user-avatar');
    
    if (!avatar.contains(event.target) && !dropdown.contains(event.target)) {
        dropdown.style.display = 'none';
    }
});
</script>